/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.helper.ParameterCheck;
import org.apache.commons.io.FilenameUtils;

public class Preferences
implements Serializable {
    private static final String SYNTACTIC_ANALYSIS = "Syntactic Analysis";
    private static final String LEXICAL_ANALYSIS = "Lexical Analysis";
    private static final long serialVersionUID = -5227627363139361867L;
    private static final String DEFAULT_LANGUAGE = "en";
    public String deflanguage;
    public ArrayList<String> languages;
    public HashMap<String, ArrayList<String>> ldic;
    public HashMap<String, ArrayList<String>> lsyn;
    public transient Font TFont;
    public transient Font DFont;
    public transient Font IFont;
    public transient Font OFont;
    public transient Font CFont;
    public String TFontName;
    public float TFontSize;
    public int TFontStyle;
    private String DFontName;
    private float DFontSize;
    private int DFontStyle;
    private String IFontName;
    private float IFontSize;
    private int IFontStyle;
    private String OFontName;
    private float OFontSize;
    private int OFontStyle;
    private String CFontName;
    private float CFontSize;
    private int CFontStyle;
    public Color AColor;
    public Color BColor;
    public Color CColor;
    public Color FColor;
    public Color SColor;
    public Color VColor;
    public boolean DispFrame;
    public boolean DispDate;
    public boolean DispFile;
    public boolean DispDir;
    public boolean DispAuthor;
    public boolean DispInstitution;
    public boolean DispState;
    public String openTextDir;
    public String openDicDir;
    public String openGrammarDir;
    public String openProjDir;

    public Preferences(String projectDirectoryPath) throws IOException {
        String ext;
        ParameterCheck.mandatoryString("projectDirectoryPath", projectDirectoryPath);
        this.languages = new ArrayList();
        File projectDirectory = new File(projectDirectoryPath);
        if (!projectDirectory.isDirectory()) {
            throw new IOException("Project directory on path '" + projectDirectory + "' doesn't exist or it exists but is not a directory");
        }
        for (File files : projectDirectory.listFiles()) {
            if (!files.isDirectory()) continue;
            String directoryName = files.getName();
            this.languages.add(directoryName);
        }
        this.deflanguage = this.languages.size() > 0 ? DEFAULT_LANGUAGE : null;
        this.ldic = new HashMap();
        for (String language : this.languages) {
            ArrayList<String> lexicalResources = new ArrayList<String>();
            File lexicalAnalysisDirectory = new File(new File(projectDirectoryPath, language), LEXICAL_ANALYSIS);
            if (lexicalAnalysisDirectory.isDirectory()) {
                for (String resource : lexicalAnalysisDirectory.list()) {
                    ext = FilenameUtils.getExtension(resource);
                    if (!ext.equals("jnod") && !ext.equals("nom") && !ext.equals("nog")) continue;
                    lexicalResources.add(resource);
                }
            } else {
                lexicalAnalysisDirectory = new File(projectDirectoryPath, language);
                if (lexicalAnalysisDirectory.isDirectory()) {
                    for (String resource : lexicalAnalysisDirectory.list()) {
                        ext = FilenameUtils.getExtension(resource);
                        if (!ext.equals("jnod") && !ext.equals("nom")) continue;
                        lexicalResources.add(resource);
                    }
                }
            }
            this.ldic.put(language, lexicalResources);
        }
        this.lsyn = new HashMap();
        for (String language : this.languages) {
            ArrayList<String> syntaticResources = new ArrayList<String>();
            File syntaticAnalysisDirectory = new File(new File(projectDirectoryPath, language), SYNTACTIC_ANALYSIS);
            if (syntaticAnalysisDirectory.isDirectory()) {
                for (String resource : syntaticAnalysisDirectory.list()) {
                    ext = FilenameUtils.getExtension(resource);
                    if (!ext.equals("nog")) continue;
                    syntaticResources.add(resource);
                }
            } else {
                syntaticAnalysisDirectory = new File(projectDirectoryPath, language);
                if (syntaticAnalysisDirectory.isDirectory()) {
                    for (String resource : syntaticAnalysisDirectory.list()) {
                        ext = FilenameUtils.getExtension(resource);
                        if (!ext.equals("nog")) continue;
                        syntaticResources.add(resource);
                    }
                }
            }
            this.lsyn.put(language, syntaticResources);
        }
        this.TFont = new Font("Times New Roman", 0, 12);
        this.DFont = new Font("Courier New", 0, 11);
        this.IFont = new Font("Times New Roman", 0, 12);
        this.OFont = new Font("Courier New", 1, 12);
        this.CFont = new Font("Times New Roman", 0, 12);
        this.AColor = Color.YELLOW;
        this.BColor = Color.WHITE;
        this.CColor = new Color(20, 180, 62);
        this.FColor = Color.BLACK;
        this.SColor = Color.BLUE;
        this.VColor = Color.RED;
        this.DispInstitution = true;
        this.DispAuthor = true;
        this.DispDir = true;
        this.DispFile = true;
        this.DispDate = true;
        this.DispFrame = true;
        this.DispState = false;
    }

    public Preferences() {
        this.languages = new ArrayList<String>(Arrays.asList(Language.getAllLanguages()));
        this.ldic = new HashMap();
        this.lsyn = new HashMap();
        if (this.languages.size() > 0) {
            this.deflanguage = DEFAULT_LANGUAGE;
        } else {
            System.out.println("NooJ: no language is available");
            this.deflanguage = null;
        }
        this.TFont = new Font("Times New Roman", 0, 12);
        this.DFont = new Font("Courier New", 0, 11);
        this.IFont = new Font("Times New Roman", 0, 12);
        this.OFont = new Font("Courier New", 1, 12);
        this.CFont = new Font("Times New Roman", 0, 12);
        this.AColor = Color.YELLOW;
        this.BColor = Color.WHITE;
        this.CColor = new Color(20, 180, 62);
        this.FColor = Color.BLACK;
        this.SColor = Color.BLUE;
        this.VColor = Color.RED;
        this.DispInstitution = true;
        this.DispAuthor = true;
        this.DispDir = true;
        this.DispFile = true;
        this.DispDate = true;
        this.DispFrame = true;
        this.DispState = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Preferences Load(String fileNamePath) {
        ParameterCheck.mandatoryString("fileNamePath", fileNamePath);
        Preferences preferences = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream serializer = null;
        if (new File(fileNamePath).isFile()) {
            try {
                fileInputStream = new FileInputStream(fileNamePath);
                serializer = new ObjectInputStream(fileInputStream);
                preferences = (Preferences)serializer.readObject();
                fileInputStream.close();
                preferences.TFont = new Font(preferences.TFontName, preferences.TFontStyle, (int)preferences.TFontSize);
                preferences.DFont = new Font(preferences.DFontName, preferences.DFontStyle, (int)preferences.DFontSize);
                preferences.IFont = new Font(preferences.IFontName, preferences.IFontStyle, (int)preferences.IFontSize);
                preferences.OFont = new Font(preferences.OFontName, preferences.OFontStyle, (int)preferences.OFontSize);
                preferences.CFont = new Font(preferences.CFontName, preferences.CFontStyle, (int)preferences.CFontSize);
            }
            catch (Exception e) {
                System.out.println("NooJ: cannot load preferences from " + fileNamePath + "\n" + e.getMessage());
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        System.out.println("Error while closing " + fileNamePath);
                    }
                }
                if (serializer != null) {
                    try {
                        serializer.close();
                    }
                    catch (IOException e) {
                        System.out.println("Error while closing " + fileNamePath);
                    }
                }
            }
        }
        return preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Save(String fileNamePath) throws IOException {
        ParameterCheck.mandatoryString("fileNamePath", fileNamePath);
        this.TFontName = this.TFont.getName();
        this.TFontSize = this.TFont.getSize();
        this.TFontStyle = this.IFont.getStyle();
        this.DFontName = this.DFont.getName();
        this.DFontSize = this.DFont.getSize();
        this.DFontStyle = this.IFont.getStyle();
        this.IFontName = this.IFont.getName();
        this.IFontSize = this.IFont.getSize();
        this.IFontStyle = this.IFont.getStyle();
        this.OFontName = this.OFont.getName();
        this.OFontSize = this.OFont.getSize();
        this.OFontStyle = this.OFont.getStyle();
        this.CFontName = this.CFont.getName();
        this.CFontSize = this.CFont.getSize();
        this.CFontStyle = this.CFont.getStyle();
        FileOutputStream fileStream = null;
        ObjectOutputStream serializer = null;
        try {
            fileStream = new FileOutputStream(fileNamePath);
            serializer = new ObjectOutputStream(fileStream);
            serializer.writeObject(this);
            serializer.flush();
        }
        catch (RuntimeException e) {
            System.out.println("NooJ: cannot save preferences in " + fileNamePath + "\n" + e.getMessage());
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    System.out.println("Error while closing " + fileNamePath);
                }
            }
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (IOException e) {
                    System.out.println("Error while closing " + fileNamePath);
                }
            }
        }
    }
}

